import os
from langchain_openai import ChatOpenAI
from langchain_core.messages import SystemMessage, HumanMessage, AIMessage

# 念のため、環境変数が設定されているかチェック
if not os.getenv("OPENAI_API_KEY"):
    os.environ["OPENAI_API_KEY"] = (
        "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"
    )

# OpenAI のチャットモデルを用意
llm = ChatOpenAI(
    model="gpt-5.1",  # 好きなモデル名に変更可（例: "gpt-4.1" など）
)

# 会話履歴
system_prompt = "あなたは日本語で丁寧に答えるアシスタントです。"
messages = [SystemMessage(content=system_prompt)]


def main():
    print("=== LangChain + ChatGPT Streaming チャット（会話履歴あり） ===")
    print("終了したいときは 'exit' または 'quit' と入力してください。\n")

    while True:
        user_input = input("あなた: ").strip()
        if user_input.lower() in {"exit", "quit"}:
            print("\nAI  : お話できて楽しかったです。また話しましょう！")
            break

        # 履歴にユーザー発話を追加
        messages.append(HumanMessage(content=user_input))

        # ストリームで応答生成
        print("AI  :", end="", flush=True)

        full_text = ""  # 完全な応答を記録する変数

        # Streaming でメッセージを受け取る
        for chunk in llm.stream(messages):
            if chunk.content:
                full_text += chunk.content
                print(chunk.content, end="", flush=True)

        print("\n")  # 見やすくするため改行

        # 最終的な AI の返答を履歴に追加
        messages.append(AIMessage(content=full_text))


if __name__ == "__main__":
    main()
