import os
from langchain_openai import ChatOpenAI
from langchain_core.prompts import ChatPromptTemplate

# 念のため、環境変数が設定されているかチェック
if not os.getenv("OPENAI_API_KEY"):
    os.environ["OPENAI_API_KEY"] = (
        "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"
    )

# OpenAI のチャットモデルを用意
llm = ChatOpenAI(
    model="gpt-5.1",  # 好きなモデル名に変更可（例: "gpt-4.1" など）
)

# 会話のひな型（プロンプト）を定義
system_prompt = "あなたは日本語で丁寧に答えるアシスタントです。"

prompt = ChatPromptTemplate.from_messages(
    [
        ("system", system_prompt),
        ("user", "{user_input}"),
    ]
)

# プロンプト → モデル の「チェーン」を作成
chain = prompt | llm


def main():
    print("=== LangChain + ChatGPT チャット ===")
    print("終了したいときは 'exit' または 'quit' と入力してください。\n")

    while True:
        user_input = input("あなた: ").strip()
        if user_input.lower() in {"exit", "quit"}:
            print("AI  : では、またお話ししましょう。さようなら！")
            break

        # LLM に問い合わせ
        print("AI  :", end="", flush=True)
        for chunk in chain.stream({"user_input": user_input}):
            if chunk.content:
                print(chunk.content, end="", flush=True)
        print("\n")


if __name__ == "__main__":
    main()
